/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.mesh.service.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.tp_link.eap.device.EventType;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eapstats.MeshInfo;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.mesh.bean.CandidateParentApInfo;
import com.tp_link.eap.domain.mesh.bean.FirstInfomRecord;
import com.tp_link.eap.domain.mesh.bean.MeshConf;
import com.tp_link.eap.domain.mesh.bean.MeshDiscoveryRecord;
import com.tp_link.eap.domain.mesh.bean.MeshRelation;
import com.tp_link.eap.domain.mesh.bean.MeshScanStatus;
import com.tp_link.eap.domain.mesh.bean.MeshStatistics;
import com.tp_link.eap.domain.mesh.bean.UplinkInfo;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.mesh.document.StatMeshInfo;
import com.tp_link.eap.domain.mesh.pojo.ChildAP;
import com.tp_link.eap.domain.mesh.pojo.ConfigChildAP;
import com.tp_link.eap.domain.mesh.pojo.GetCandidateParents;
import com.tp_link.eap.domain.mesh.pojo.IsolatedAP;
import com.tp_link.eap.domain.mesh.pojo.Mesh;
import com.tp_link.eap.domain.mesh.pojo.Parent;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.service.d;
import com.tp_link.eap.monitor.mesh.repo.StatMeshInfoRepository;
import com.tp_link.eap.monitor.mesh.service.c;
import com.tp_link.eap.monitor.mesh.service.impl.a;
import com.tp_link.eap.monitor.mesh.service.impl.b;
import com.tp_link.eap.monitor.monitor.cache.CacheTask;
import com.tp_link.eap.monitor.monitor.realtime.RealtimeStatus;
import com.tp_link.eap.monitor.monitor.service.j;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.impl.ControllerSettingServiceImpl;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="statMeshService")
public class StatMeshService
extends com.tp_link.eap.i.a.a<StatMeshInfo>
implements c {
    @Autowired
    private StatMeshInfoRepository a;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b b;
    @Autowired
    private d c;
    @Autowired
    private j d;
    @Autowired
    private com.tp_link.eap.monitor.record.service.b e;
    @Autowired
    private ControllerSettingServiceImpl f;
    @Autowired
    private MongoTemplate g;
    private static final Logger h = LoggerFactory.getLogger(StatMeshService.class);
    private static final int i = 4;
    private static final int j = 15000;

    @Override
    public StatMeshInfo getStatMeshByMac(String mac) {
        return this.a.findByMac(mac);
    }

    @Override
    public void deleteStatMeshInfo(String mac) {
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(mac);
        if (statMeshInfo != null) {
            this.a.delete(statMeshInfo);
        }
    }

    @Override
    public boolean saveStatMesh(StatMeshInfo statMesh) {
        if (statMesh == null) {
            return false;
        }
        this.a.save(statMesh);
        return true;
    }

    @Override
    public void handleMeshInfo(String mac, MeshInfo meshInfo, boolean wirelessLinked) {
        MeshSetting meshSetting = this.c.getMeshSettingByMac(mac);
        if (meshSetting != null) {
            if (meshSetting.isMeshEnable()) {
                this.a(mac, meshInfo);
                this.c(mac, meshInfo);
            }
            this.b.clearWirelessInfo(mac, meshInfo, wirelessLinked);
        }
    }

    private void a(String string, MeshInfo meshInfo) {
        if (meshInfo == null) {
            return;
        }
        List list = meshInfo.getIsolatedAPs();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        String string2 = this.f.getControllerId();
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            return;
        }
        for (IsolatedAP isolatedAP : list) {
            Ap ap;
            if (isolatedAP.getMac().equals(string) || com.tp_link.eap.util.a.e.a((String)isolatedAP.getControllerId()) || isolatedAP.getFactory() == null || this.b(isolatedAP.getMac(), meshInfo) || MeshDiscoveryRecord.isExit((String)isolatedAP.getMac()) || (ap = this.b.getApByMac(string)) == null) continue;
            String string3 = ap.getSite();
            Ap ap2 = this.b.getApByMac(isolatedAP.getMac());
            if (ap2 == null) {
                int n2 = isolatedAP.getFactory() == true ? 0 : (isolatedAP.getControllerId().equalsIgnoreCase("c21f969b5f03d33d43e04f8f136e7682") ? 1 : (isolatedAP.getControllerId().equalsIgnoreCase(string2) ? 1 : 2));
                this.b.createWirelessPendingAp(isolatedAP, n2, string3);
                this.a(string, isolatedAP);
                continue;
            }
            if (this.a(ap2.getMac())) continue;
            if (isolatedAP.getFactory().booleanValue()) {
                this.b.updateWirelessPendingAp(isolatedAP, 0, string3);
                this.b(string, isolatedAP);
                continue;
            }
            if (isolatedAP.getControllerId().equalsIgnoreCase("c21f969b5f03d33d43e04f8f136e7682")) {
                if (ap2.getStatus() == 2) {
                    this.b.updateWirelessPendingAp(isolatedAP, 1, string3);
                    this.b(string, isolatedAP);
                    continue;
                }
                if (com.tp_link.eap.util.a.e.a((String)ap2.getSite()) || !ap2.getSite().equals(ap.getSite())) continue;
                StatMeshInfo statMeshInfo = this.getStatMeshByMac(isolatedAP.getMac());
                if (ap2.getWirelessLinked().booleanValue() && (statMeshInfo == null || statMeshInfo.getUplinkInfo() == null || statMeshInfo != null && statMeshInfo.getUplinkInfo() != null && l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)60000L))) {
                    this.b(string, isolatedAP);
                    this.b.setApToIsolated(ap2.getMac());
                }
                if (ap2.getWirelessLinked().booleanValue() || !l.a((long)ap2.getLastSeen(), (long)60000L)) continue;
                this.b(string, isolatedAP);
                this.b.setApToIsolated(ap2.getMac());
                continue;
            }
            String string4 = null;
            if (ap2 != null && ap2.getControllerSetting() != null) {
                string4 = ap2.getControllerSetting().getControllerId();
            }
            if (isolatedAP.getControllerId().equalsIgnoreCase("984c6138187e74c88a7bef0a2ad8b31a")) {
                if (ap2.getStatus() != 2 || ap2.getManagedMark() != 2) {
                    this.deleteMeshConf(ap2);
                    this.b.transManagedOther(ap2.getMac());
                    continue;
                }
                this.b.updateWirelessPendingAp(isolatedAP, 2, string3);
                this.b(string, isolatedAP);
                continue;
            }
            if (isolatedAP.getControllerId().equalsIgnoreCase(string2)) {
                if (ap2.getStatus() == 2 && ap2.getManagedMark() == 1) {
                    this.b.updateWirelessPendingAp(isolatedAP, 1, string3);
                    this.b(string, isolatedAP);
                    continue;
                }
            } else if (isolatedAP.getControllerId().equalsIgnoreCase(string2) || com.tp_link.eap.util.a.e.a((String)string4) || !string4.equalsIgnoreCase(isolatedAP.getControllerId())) {
                if (ap2.getStatus() != 2 || ap2.getManagedMark() != 2) {
                    this.deleteMeshConf(ap2);
                    this.b.transManagedOther(ap2.getMac());
                    continue;
                }
                this.b.updateWirelessPendingAp(isolatedAP, 2, string3);
                this.b(string, isolatedAP);
                continue;
            }
            if (com.tp_link.eap.util.a.e.a((String)ap2.getSite()) || !ap2.getSite().equals(ap.getSite())) continue;
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(isolatedAP.getMac());
            if (ap2.getWirelessLinked().booleanValue() && (statMeshInfo == null || statMeshInfo.getUplinkInfo() == null || statMeshInfo != null && statMeshInfo.getUplinkInfo() != null && l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)60000L))) {
                this.b(string, isolatedAP);
                this.b.setApToIsolated(ap2.getMac());
            }
            if (ap2.getWirelessLinked().booleanValue() || !l.a((long)ap2.getLastSeen(), (long)60000L)) continue;
            this.b(string, isolatedAP);
            this.b.setApToIsolated(ap2.getMac());
        }
    }

    private void a(String string, IsolatedAP isolatedAP) {
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(isolatedAP.getMac());
        if (statMeshInfo != null) {
            this.deleteStatMeshInfo(isolatedAP.getMac());
        }
        this.c(string, isolatedAP);
    }

    private void b(String string, IsolatedAP isolatedAP) {
        h.debug("parentApMac: " + string);
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(isolatedAP.getMac());
        if (statMeshInfo == null || statMeshInfo.getUplinkInfo() == null || statMeshInfo.getUplinkInfo() != null && l.a((long)statMeshInfo.getUplinkInfo().getUptime().getTime(), (long)60000L)) {
            this.c(string, isolatedAP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(String string, IsolatedAP isolatedAP) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.p((String)isolatedAP.getMac());
        synchronized (object2) {
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(isolatedAP.getMac());
            if (statMeshInfo == null) {
                statMeshInfo = new StatMeshInfo();
                statMeshInfo.setMac(isolatedAP.getMac());
            }
            statMeshInfo.setModel(isolatedAP.getModel());
            statMeshInfo.setModelVersion(isolatedAP.getModelVersion());
            statMeshInfo.setUpdateTime(new Date());
            CandidateParentApInfo candidateParentApInfo = null;
            ArrayList<CandidateParentApInfo> arrayList = statMeshInfo.getCandidateParentAps();
            if (!CollectionUtils.isEmpty((Collection)arrayList)) {
                for (CandidateParentApInfo candidateParentApInfo2 : arrayList) {
                    if (!candidateParentApInfo2.getMac().equalsIgnoreCase(string)) continue;
                    candidateParentApInfo = candidateParentApInfo2;
                    break;
                }
            } else {
                arrayList = new ArrayList<CandidateParentApInfo>();
            }
            if (candidateParentApInfo == null) {
                candidateParentApInfo = new CandidateParentApInfo();
                arrayList.add(candidateParentApInfo);
            }
            candidateParentApInfo.setChannel(isolatedAP.getChannel());
            candidateParentApInfo.setMac(string);
            candidateParentApInfo.setRssi(isolatedAP.getRssi());
            candidateParentApInfo.setSnr(Integer.valueOf(isolatedAP.getSnr()));
            candidateParentApInfo.setUptime(new Date());
            statMeshInfo.setCandidateParentAps(arrayList);
            statMeshInfo.setUpdateTime(new Date());
            this.saveStatMesh(statMeshInfo);
        }
    }

    private boolean b(String string, MeshInfo meshInfo) {
        List list;
        boolean bl = false;
        if (meshInfo != null && !CollectionUtils.isEmpty((Collection)(list = meshInfo.getChildAPs()))) {
            for (ChildAP childAP : list) {
                if (!childAP.getMac().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean a(String string) {
        Ap ap = this.b.getApByMac(string);
        return ap != null && ap.getStatus().equals(1) && System.currentTimeMillis() - ap.getLastSeen() < 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(String string, MeshInfo meshInfo) {
        Object object;
        Parent parent;
        StatMeshInfo statMeshInfo;
        Object object2;
        Object object3;
        String string2;
        ChildAP childAP;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (meshInfo == null) {
            return;
        }
        h.debug("updateChildAndCandidateParents {}", (Object)string);
        if (meshInfo.getCandidateParents() != null) {
            h.debug("handle candidateParents of {} ", (Object)string);
            object7 = meshInfo.getCandidateParents();
            if (object7.getStatus() == 0) {
                MeshScanStatus.refreshHalf((String)string);
            } else if (object7.getStatus() == 1) {
                MeshScanStatus.refreshScanning((String)string);
            } else {
                MeshScanStatus.refreshFail((String)string);
            }
            object6 = object7.getParentList();
            if (object6 != null) {
                MeshScanStatus.refreshComplete((String)string);
                if (!CollectionUtils.isEmpty((Collection)object6)) {
                    object4 = object5 = com.tp_link.eap.b.b.a.p((String)string);
                    synchronized (object4) {
                        childAP = this.getStatMeshByMac(string);
                        if (childAP == null) {
                            childAP = new StatMeshInfo();
                            childAP.setMac(string);
                        }
                        string2 = childAP.getTryParent();
                        boolean bl = false;
                        object3 = new ArrayList();
                        object2 = childAP.getCandidateParentAps();
                        statMeshInfo = object6.iterator();
                        while (statMeshInfo.hasNext()) {
                            parent = (Parent)statMeshInfo.next();
                            if (!com.tp_link.eap.util.a.e.a((String)string2) && parent.getMac().equals(string2)) {
                                bl = true;
                            }
                            if ((object = this.b.getApByMac(parent.getMac())) == null || object.getStatus() != 1) continue;
                            CandidateParentApInfo candidateParentApInfo = new CandidateParentApInfo();
                            candidateParentApInfo.setMac(parent.getMac());
                            candidateParentApInfo.setChannel(parent.getChannel());
                            candidateParentApInfo.setRssi(parent.getRssi());
                            candidateParentApInfo.setSnr(Integer.valueOf(parent.getSnr()));
                            candidateParentApInfo.setUptime(new Date());
                            object3.add(candidateParentApInfo);
                        }
                        if (!(bl || com.tp_link.eap.util.a.e.a((String)string2) || CollectionUtils.isEmpty((Collection)object2))) {
                            statMeshInfo = object2.iterator();
                            while (statMeshInfo.hasNext()) {
                                parent = (CandidateParentApInfo)statMeshInfo.next();
                                if (!parent.getMac().equals(string2)) continue;
                                object3.add(parent);
                            }
                        }
                        childAP.setCandidateParentAps(object3);
                        childAP.setUpdateTime(new Date());
                        this.saveStatMesh((StatMeshInfo)childAP);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)meshInfo.getChildAPs())) {
            h.debug("handle childAPs of {} ", (Object)string);
            object7 = meshInfo.getChildAPs();
            object6 = this.b.getApByMac(string);
            object5 = new HashSet();
            if (object6 != null && object6.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)object6.getMeshConf().getChildApMacs())) {
                object5 = object6.getMeshConf().getChildApMacs();
            }
            object4 = object7.iterator();
            while (object4.hasNext()) {
                childAP = (ChildAP)object4.next();
                string2 = childAP.getMac();
                h.debug("handle childAP - parent: {} child: {} ", (Object)string, (Object)string2);
                if (!object5.contains(string2)) {
                    h.debug("deleteRelationship - parent: {} child: {} ", (Object)string, (Object)string2);
                    this.deleteRelationship(string, string2, true);
                    this.sendDisconnectCommand(string, string2);
                    continue;
                }
                Ap ap = this.b.getApByMac(string2);
                if (ap == null || ap.getMeshConf() == null || com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac()) || !ap.getMeshConf().getParentApMac().equals(string)) {
                    h.debug("deleteRelationship - parent: {} child: {} ", (Object)string, (Object)string2);
                    this.deleteRelationship(string, string2, true);
                    this.sendDisconnectCommand(string, string2);
                    continue;
                }
                if (!ap.getSite().equals("PENDING-SITE") && !ap.getSite().equals(object6.getSite())) continue;
                object2 = object3 = com.tp_link.eap.b.b.a.p((String)string2);
                synchronized (object2) {
                    statMeshInfo = this.getStatMeshByMac(string2);
                    if (statMeshInfo == null) {
                        statMeshInfo = new StatMeshInfo();
                        statMeshInfo.setMac(string2);
                    }
                    if ((parent = statMeshInfo.getUplinkInfo()) == null) {
                        parent = new UplinkInfo();
                    }
                    parent.setMac(string);
                    parent.setRssi(childAP.getRssi());
                    parent.setSnr(Integer.valueOf(childAP.getSnr()));
                    parent.setTxRate(childAP.getTxRate());
                    parent.setRxRate(childAP.getRxRate());
                    parent.setUpPackets(childAP.getUpPackets());
                    parent.setDownPackets(childAP.getDownPackets());
                    parent.setActivity(this.a(childAP.getUpBytes(), childAP.getDownBytes(), parent.getUpBytes(), parent.getDownBytes()));
                    parent.setUpBytes(childAP.getUpBytes());
                    parent.setDownBytes(childAP.getDownBytes());
                    parent.setUptime(new Date());
                    statMeshInfo.setUplinkInfo((UplinkInfo)parent);
                    statMeshInfo.setStatus(Integer.valueOf(2));
                    object = statMeshInfo.getCandidateParentAps();
                    if (!CollectionUtils.isEmpty((Collection)object)) {
                        boolean bl = false;
                        for (int i2 = 0; i2 < object.size(); ++i2) {
                            if (!((CandidateParentApInfo)object.get(i2)).getMac().equals(string)) continue;
                            bl = true;
                            ((CandidateParentApInfo)object.get(i2)).setRssi(parent.getRssi());
                            ((CandidateParentApInfo)object.get(i2)).setUptime(new Date());
                            break;
                        }
                        if (!bl) {
                            // empty if block
                        }
                        statMeshInfo.setCandidateParentAps((List)object);
                    }
                    statMeshInfo.setUpdateTime(new Date());
                    this.saveStatMesh(statMeshInfo);
                }
            }
        }
    }

    @Override
    public OperationResponse refreshCandidateParents(String childMac) {
        if (com.tp_link.eap.util.a.e.a((String)childMac)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = childMac;
        if (MeshScanStatus.isScanning((String)string) || MeshScanStatus.isHalf((String)string)) {
            return new OperationResponse(ResErrorCode.dN);
        }
        Ap ap = this.b.getApByMac(childMac);
        if (ap == null || ap.getStatus() != 1 || ap.getRealtimeStatus() != RealtimeStatus.a.ordinal() && ap.getRealtimeStatus() != RealtimeStatus.d.ordinal()) {
            return new OperationResponse(ResErrorCode.dO);
        }
        this.b(childMac);
        this.c(childMac);
        if (MeshScanStatus.isFail((String)string)) {
            MeshScanStatus.refreshFail((String)string);
            return new OperationResponse(ResErrorCode.dP);
        }
        if (!MeshScanStatus.isHalf((String)string)) {
            MeshScanStatus.refreshFail((String)string);
            return new OperationResponse(ResErrorCode.dQ);
        }
        this.d(childMac);
        int n2 = 0;
        while (!MeshScanStatus.isComplete((String)string) && n2 < 4) {
            try {
                Thread.sleep(5000L);
                ++n2;
            }
            catch (InterruptedException interruptedException) {
                h.warn("get an exception while wating getting candidate parents for mac : " + string, (Throwable)interruptedException);
            }
        }
        if (!MeshScanStatus.isComplete((String)string)) {
            MeshScanStatus.refreshFail((String)string);
            return new OperationResponse(ResErrorCode.dP);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private void b(String string) {
        MeshScanStatus.refreshScanning((String)string);
        EapConfigBody eapConfigBody = this.a(0);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, string);
    }

    private int c(String string) {
        int n2 = 0;
        EapConfigBody eapConfigBody = this.a(1);
        while (!MeshScanStatus.isHalf((String)string) && n2 < 4) {
            try {
                Thread.sleep(15000L);
                ++n2;
                com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, string);
            }
            catch (InterruptedException interruptedException) {
                h.warn("get an exception while wating getting cscanning status for mac : " + string, (Throwable)interruptedException);
            }
        }
        return n2;
    }

    private void d(String string) {
        EapConfigBody eapConfigBody = this.a(2);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, string);
    }

    private EapConfigBody a(int n2) {
        GetCandidateParents getCandidateParents = new GetCandidateParents();
        getCandidateParents.setAction(Integer.valueOf(n2));
        Mesh mesh = new Mesh();
        mesh.setGetCandidateParents(getCandidateParents);
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setSequenceId(Integer.valueOf(65537));
        eapConfigBody.setMesh(mesh);
        return eapConfigBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse changeParentAp(String childMac, String newParentMac, String username, String password) {
        OperationResponse operationResponse;
        Object object;
        h.debug("changeParentAp childMac: {} newParentMac:  {}", (Object)childMac, (Object)newParentMac);
        if (com.tp_link.eap.util.restore.c.g() != null && !com.tp_link.eap.util.restore.c.g().isFinished()) {
            h.warn("Restore is progressing");
            return new OperationResponse(ResErrorCode.dy);
        }
        if (com.tp_link.eap.util.a.e.a((String)childMac) || com.tp_link.eap.util.a.e.a((String)newParentMac)) {
            return new OperationResponse(ResErrorCode.dx);
        }
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(childMac);
        if (statMeshInfo != null && statMeshInfo.getStatus() == 1 && !l.a((long)statMeshInfo.getTryTime().getTime(), (long)120000L)) {
            return new OperationResponse(ResErrorCode.dz);
        }
        Ap ap = this.b.getApByMac(childMac);
        if (ap == null) {
            return new OperationResponse(ResErrorCode.dA);
        }
        if (!ap.getWirelessLinked().booleanValue() || ap.getStatus() == 1 && ap.getRealtimeStatus() != RealtimeStatus.a.ordinal() && ap.getRealtimeStatus() != RealtimeStatus.d.ordinal()) {
            return new OperationResponse(ResErrorCode.dC);
        }
        String string = null;
        if (ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac()) && newParentMac.equals(string = ap.getMeshConf().getParentApMac())) {
            h.debug("no change");
            this.refreshStatus(childMac, 2);
            return com.tp_link.eap.util.e.bd;
        }
        Ap ap2 = this.b.getApByMac(newParentMac);
        String string2 = com.tp_link.eap.d.b.a();
        Object object2 = object = com.tp_link.eap.b.b.a.j((String)string2);
        synchronized (object2) {
            operationResponse = this.isValidParent(ap, ap2);
            if (operationResponse != null && !operationResponse.success() && operationResponse.getErrorCode() != ResErrorCode.dK.a()) {
                return operationResponse;
            }
            this.refreshStatus(childMac, 1);
            if (this.calcChildApCnt(ap2) >= 4) {
                String string3 = this.giveDisChild(ap2);
                if (!com.tp_link.eap.util.a.e.a((String)string3)) {
                    h.debug("disConnectParentAp");
                    this.disConnectParentAp(string3, newParentMac, false, true, false);
                } else {
                    return new OperationResponse(ResErrorCode.dI);
                }
            }
            if (operationResponse != null && operationResponse.getErrorCode() == ResErrorCode.dK.a()) {
                h.debug("handle overHop");
                this.a(this.b.getApByMac(childMac), newParentMac);
            }
            this.saveMeshConf(childMac, newParentMac);
        }
        if (ap.getStatus() == 2 && ap.getWirelessLinked().booleanValue()) {
            if (com.tp_link.eap.util.a.e.a((String)username) || com.tp_link.eap.util.a.e.a((String)password)) {
                username = "admin";
                password = "admin";
            }
            if (!(object2 = this.b.adoptAp(childMac, username, password, newParentMac)).success()) {
                return object2;
            }
        } else {
            if (!com.tp_link.eap.util.a.e.a((String)string)) {
                h.debug("disConnectParentAp");
                object2 = this.disConnectParentAp(childMac, string, true, true, false);
                if (object2 != null && !object2.isSuccess()) {
                    h.debug("deleteRelationship");
                    this.deleteRelationship(newParentMac, childMac, false);
                    this.refreshStatus(childMac, 3);
                    return new OperationResponse(ResErrorCode.dM);
                }
            } else {
                if (com.tp_link.eap.h.d.c.d((String)childMac)) {
                    com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, childMac);
                }
                CacheTask.a.a(childMac);
            }
            if (com.tp_link.eap.util.a.e.a((String)username) || com.tp_link.eap.util.a.e.a((String)password)) {
                object2 = this.b.getApByMac(childMac);
                if (object2 != null && object2.getAdoptInfo() != null) {
                    username = object2.getAdoptInfo().getUsername();
                    password = object2.getAdoptInfo().getPassword();
                }
                if (com.tp_link.eap.util.a.e.a((String)username) || com.tp_link.eap.util.a.e.a((String)password)) {
                    h.warn("username null");
                    operationResponse = this.c.getUserAccountSetting();
                    username = operationResponse.getUserName();
                    password = operationResponse.getPassword();
                }
            }
            int n2 = 15;
            int n3 = 0;
            com.tp_link.eap.util.o.b.b((Integer)65538, (String)newParentMac);
            this.sendAddCommand(newParentMac, childMac, username, password);
            for (int i2 = 0; i2 < n2 && n3 != 2; ++i2) {
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    h.warn(interruptedException.toString(), (Throwable)interruptedException);
                }
                n3 = com.tp_link.eap.util.o.b.c((Integer)65538, (String)newParentMac);
            }
            n3 = com.tp_link.eap.util.o.b.c((Integer)65538, (String)newParentMac);
            com.tp_link.eap.util.o.b.d((Integer)65538, (String)newParentMac);
            if (n3 != 2) {
                h.debug("no sendAddCommand response {}", (Object)newParentMac);
                this.sendDisconnectCommand(newParentMac, childMac);
                this.deleteRelationship(newParentMac, childMac, false);
                this.refreshStatus(childMac, 3);
                return new OperationResponse(ResErrorCode.dL);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse isValidParent(Ap childAp, Ap candidateParentAp) {
        if (candidateParentAp == null) {
            return new OperationResponse(ResErrorCode.dD);
        }
        String string = childAp.getMac();
        String string2 = candidateParentAp.getMac();
        if (string2.equals(string)) {
            return new OperationResponse(ResErrorCode.dB);
        }
        if (candidateParentAp.getStatus() != 1) {
            return new OperationResponse(ResErrorCode.dF);
        }
        if (candidateParentAp.getRealtimeStatus() != RealtimeStatus.a.ordinal() && candidateParentAp.getRealtimeStatus() != RealtimeStatus.d.ordinal()) {
            return new OperationResponse(ResErrorCode.dG);
        }
        if (FirstInfomRecord.isExit((String)candidateParentAp.getMac())) {
            return new OperationResponse(ResErrorCode.dH);
        }
        if (candidateParentAp.getMeshConf() != null && candidateParentAp.getMeshConf().getChildApMacs() != null && candidateParentAp.getMeshConf().getChildApMacs().size() >= 4 && this.getDisChildNum(candidateParentAp) == 0) {
            return new OperationResponse(ResErrorCode.dJ);
        }
        if (this.isOffspring(string, string2)) {
            return new OperationResponse(ResErrorCode.dE);
        }
        int n2 = 0;
        n2 = this.getHop(string2);
        int n3 = this.getGenerations(string);
        if (n2 < 3 && n2 + n3 > 3) {
            return new OperationResponse(ResErrorCode.dK);
        }
        if (n2 + n3 > 3) {
            return new OperationResponse(ResErrorCode.dJ);
        }
        return com.tp_link.eap.util.e.bd;
    }

    public void sendQuickSwitch(String childMac, boolean discoveryReset) {
        Mesh mesh = new Mesh();
        mesh.setScanParent(1);
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setMesh(mesh);
        eapConfigBody.setSequenceId(Integer.valueOf(65540));
        if (this.e.getSettingVersion(childMac) != null) {
            Integer n2 = this.e.getSettingVersion(childMac).getBase();
            eapConfigBody.setConfigVersion(n2);
        }
        h.debug("sendQuickSwitch to " + childMac);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, childMac);
    }

    @Override
    public void sendDisconnectCommand(String parentMac, String childMac) {
        if (com.tp_link.eap.util.a.e.a((String)parentMac) || com.tp_link.eap.util.a.e.a((String)childMac)) {
            return;
        }
        h.debug("sendDisconnectCommand parentMac: {}  childMac: {}", (Object)parentMac, (Object)childMac);
        ArrayList<ConfigChildAP> arrayList = new ArrayList<ConfigChildAP>();
        ConfigChildAP configChildAP = new ConfigChildAP();
        configChildAP.setMac(childMac);
        configChildAP.setAction(Integer.valueOf(0));
        arrayList.add(configChildAP);
        Mesh mesh = new Mesh();
        mesh.setConfigChildAPList(arrayList);
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setMesh(mesh);
        eapConfigBody.setSequenceId(Integer.valueOf(65539));
        if (this.e.getSettingVersion(parentMac) != null) {
            Integer n2 = this.e.getSettingVersion(parentMac).getBase();
            eapConfigBody.setConfigVersion(n2);
        }
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, parentMac);
    }

    @Override
    public void sendAddCommand(String parentMac, String childMac, String username, String password) {
        if (com.tp_link.eap.util.a.e.a((String)parentMac) || com.tp_link.eap.util.a.e.a((String)childMac) || com.tp_link.eap.util.a.e.a((String)username) || com.tp_link.eap.util.a.e.a((String)password)) {
            return;
        }
        ArrayList<ConfigChildAP> arrayList = new ArrayList<ConfigChildAP>();
        ConfigChildAP configChildAP = new ConfigChildAP();
        configChildAP.setMac(childMac);
        configChildAP.setAction(Integer.valueOf(1));
        configChildAP.setUsername(username);
        configChildAP.setPassword(com.tp_link.eap.util.e.a.a((String)password));
        arrayList.add(configChildAP);
        Mesh mesh = new Mesh();
        mesh.setConfigChildAPList(arrayList);
        EapConfigBody eapConfigBody = new EapConfigBody();
        eapConfigBody.setMesh(mesh);
        eapConfigBody.setSequenceId(Integer.valueOf(65538));
        if (this.e.getSettingVersion(parentMac) != null) {
            Integer n2 = this.e.getSettingVersion(parentMac).getBase();
            eapConfigBody.setConfigVersion(n2);
        }
        h.debug("sendAddCommand " + arrayList + "to " + parentMac);
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, eapConfigBody, parentMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMeshConf(String childMac, String newParentMac) {
        Object object;
        Ap ap;
        Object object2;
        Object object3;
        Object object4;
        if (com.tp_link.eap.util.a.e.a((String)childMac) || com.tp_link.eap.util.a.e.a((String)newParentMac)) {
            return;
        }
        Ap ap2 = this.b.getApByMac(childMac);
        if (ap2 != null && ap2.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)(object4 = ap2.getMeshConf()).getParentApMac()) && !object4.getParentApMac().equals(newParentMac)) {
            object3 = com.tp_link.eap.b.b.a.a((String)object4.getParentApMac());
            object2 = object3;
            synchronized (object2) {
                ap = this.b.getApByMac(object4.getParentApMac());
                if (ap != null && ap.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) {
                    object = ap.getMeshConf().getChildApMacs();
                    if (object.contains(ap2.getMac())) {
                        object.remove(ap2.getMac());
                    }
                    this.b.refreshAp(ap);
                }
            }
        }
        object3 = object4 = com.tp_link.eap.b.b.a.a((String)childMac);
        synchronized (object3) {
            ap2 = this.b.getApByMac(childMac);
            if (ap2 != null) {
                object2 = ap2.getMeshConf();
                if (object2 == null) {
                    object2 = new MeshConf();
                }
                object2.setParentApMac(newParentMac);
                ap2.setMeshConf(object2);
                this.b.refreshAp(ap2);
            }
        }
        object3 = com.tp_link.eap.b.b.a.a((String)newParentMac);
        object2 = object3;
        synchronized (object2) {
            ap = this.b.getApByMac(newParentMac);
            if (ap != null) {
                object = ap.getMeshConf();
                if (object == null) {
                    object = new MeshConf();
                }
                Set set = object.getChildApMacs();
                set.add(childMac);
                object.setChildApMacs(set);
                ap.setMeshConf((MeshConf)object);
                this.b.refreshAp(ap);
            }
        }
        this.a(childMac, newParentMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMeshConf(Ap ap) {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        if (ap == null || ap.getMeshConf() == null) {
            return;
        }
        h.debug("deleteMeshConf {}", (Object)ap.getMac());
        if (!CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) {
            object4 = ap.getMeshConf().getChildApMacs();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                object = object2 = com.tp_link.eap.b.b.a.a((String)string);
                synchronized (object) {
                    MeshConf meshConf;
                    Ap ap2 = this.b.getApByMac(string);
                    if (ap2 != null && (meshConf = ap2.getMeshConf()) != null && !com.tp_link.eap.util.a.e.a((String)meshConf.getParentApMac()) && meshConf.getParentApMac().equals(ap.getMac())) {
                        meshConf.setParentApMac(null);
                        ap2.setMeshConf(meshConf);
                        this.b.refreshAp(ap2);
                    }
                }
            }
        }
        if (!com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
            object3 = object4 = com.tp_link.eap.b.b.a.a((String)ap.getMeshConf().getParentApMac());
            synchronized (object3) {
                string = this.b.getApByMac(ap.getMeshConf().getParentApMac());
                if (string != null && (object2 = string.getMeshConf()) != null && (object = object2.getChildApMacs()) != null && object.contains(ap.getMac())) {
                    object.remove(ap.getMac());
                    object2.setChildApMacs((Set)object);
                    string.setMeshConf((MeshConf)object2);
                    this.b.refreshAp((Ap)string);
                }
            }
        }
        object3 = object4 = com.tp_link.eap.b.b.a.a((String)ap.getMac());
        synchronized (object3) {
            string = this.b.getApByMac(ap.getMac());
            if (string != null) {
                string.setMeshConf(new MeshConf());
                this.b.refreshAp((Ap)string);
            }
        }
    }

    @Override
    public OperationResult disConnectParentAp(String childMac, String parentMac, boolean needQuickSwitch, boolean delTryParent, boolean discoveryReset) {
        h.debug("disConnectParentAp");
        this.deleteRelationship(parentMac, childMac, delTryParent);
        if (needQuickSwitch) {
            this.sendQuickSwitch(childMac, discoveryReset);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                h.warn(interruptedException.toString(), (Throwable)interruptedException);
            }
        }
        this.sendDisconnectCommand(parentMac, childMac);
        if (com.tp_link.eap.h.d.c.d((String)childMac)) {
            com.tp_link.eap.monitor.a.a.a(EventType.EVENT_CLEAR_AP, null, null, childMac);
        }
        CacheTask.a.a(childMac);
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRelationship(String parentMac, String childMac, boolean clearTryParentHistory) {
        MeshConf meshConf;
        Object object;
        Object object2;
        h.debug("deleteRelationship- parentMac: " + parentMac + " childMac: " + childMac + clearTryParentHistory);
        Object object3 = object2 = com.tp_link.eap.b.b.a.a((String)childMac);
        synchronized (object3) {
            object = this.b.getApByMac(childMac);
            if (object != null && (meshConf = object.getMeshConf()) != null && !com.tp_link.eap.util.a.e.a((String)meshConf.getParentApMac()) && meshConf.getParentApMac().trim().equals(parentMac.trim())) {
                meshConf.setParentApMac(null);
                object.setMeshConf(meshConf);
                this.b.refreshAp((Ap)object);
            }
        }
        object3 = com.tp_link.eap.b.b.a.p((String)childMac);
        object = object3;
        synchronized (object) {
            meshConf = this.getStatMeshByMac(childMac);
            if (meshConf != null) {
                if (!com.tp_link.eap.util.a.e.a((String)meshConf.getTryParent()) && meshConf.getTryParent().equals(parentMac) && clearTryParentHistory) {
                    meshConf.setTryParent("");
                }
                this.saveStatMesh((StatMeshInfo)meshConf);
            }
        }
        object = com.tp_link.eap.b.b.a.a((String)parentMac);
        meshConf = object;
        synchronized (meshConf) {
            Set set;
            MeshConf meshConf2;
            Ap ap = this.b.getApByMac(parentMac);
            if (ap != null && (meshConf2 = ap.getMeshConf()) != null && (set = meshConf2.getChildApMacs()) != null && set.contains(childMac)) {
                set.remove(childMac);
                meshConf2.setChildApMacs(set);
                ap.setMeshConf(meshConf2);
                this.b.refreshAp(ap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshStatus(String mac, int status) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.p((String)mac);
        synchronized (object2) {
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(mac);
            if (statMeshInfo != null) {
                statMeshInfo.setStatus(Integer.valueOf(status));
                this.saveStatMesh(statMeshInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, String string2) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.p((String)string);
        synchronized (object2) {
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(string);
            if (statMeshInfo != null) {
                statMeshInfo.setTryParent(string2);
                statMeshInfo.setTryTime(new Date());
                this.saveStatMesh(statMeshInfo);
            }
        }
    }

    @Override
    public List<ChildAP> getChildAps(String mac) {
        ArrayList<ChildAP> arrayList = new ArrayList<ChildAP>();
        Ap ap = this.b.getApByMac(mac);
        if (ap == null) {
            return arrayList;
        }
        MeshConf meshConf = ap.getMeshConf();
        if (meshConf != null && !CollectionUtils.isEmpty((Collection)meshConf.getChildApMacs())) {
            Set set = meshConf.getChildApMacs();
            for (String string : set) {
                Ap ap2;
                StatMeshInfo statMeshInfo = this.getStatMeshByMac(string);
                if (statMeshInfo == null) continue;
                UplinkInfo uplinkInfo = statMeshInfo.getUplinkInfo();
                boolean bl = false;
                if (!com.tp_link.eap.util.a.e.a((String)statMeshInfo.getTryParent()) && statMeshInfo.getTryParent().equals(mac) && uplinkInfo != null && !l.a((long)uplinkInfo.getUptime().getTime(), (long)120000L)) {
                    bl = true;
                }
                if (statMeshInfo.getStatus() == 1) {
                    bl = true;
                }
                if ((ap2 = this.b.getApByMac(string)) != null && ap2.getStatus() == 1 && !l.a((long)ap2.getLastSeen(), (long)450000L)) {
                    bl = true;
                }
                if (ap2 != null && ap2.getStatus() == 0 && l.a((long)ap2.getLastSeen(), (long)(com.tp_link.eap.c.a.a * 1000))) {
                    bl = false;
                }
                if (!bl) continue;
                ChildAP childAP = new ChildAP();
                childAP.setMac(string);
                if (uplinkInfo != null) {
                    childAP.setRssi(uplinkInfo.getRssi());
                } else {
                    List list = statMeshInfo.getCandidateParentAps();
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        for (CandidateParentApInfo candidateParentApInfo : list) {
                            if (!candidateParentApInfo.getMac().equals(mac)) continue;
                            childAP.setRssi(candidateParentApInfo.getRssi());
                        }
                    }
                }
                childAP.setApName(ap2.getName());
                arrayList.add(childAP);
            }
        }
        return arrayList;
    }

    @Override
    public int getChildApsNum(String mac) {
        int n2 = 0;
        Ap ap = this.b.getApByMac(mac);
        if (ap == null) {
            return n2;
        }
        MeshConf meshConf = ap.getMeshConf();
        if (meshConf != null && !CollectionUtils.isEmpty((Collection)meshConf.getChildApMacs())) {
            Set set = meshConf.getChildApMacs();
            for (String string : set) {
                Ap ap2;
                StatMeshInfo statMeshInfo = this.getStatMeshByMac(string);
                if (statMeshInfo == null) continue;
                UplinkInfo uplinkInfo = statMeshInfo.getUplinkInfo();
                boolean bl = false;
                if (!com.tp_link.eap.util.a.e.a((String)statMeshInfo.getTryParent()) && statMeshInfo.getTryParent().equals(mac) && uplinkInfo != null && !l.a((long)uplinkInfo.getUptime().getTime(), (long)120000L)) {
                    bl = true;
                }
                if (statMeshInfo.getStatus() == 1) {
                    bl = true;
                }
                if ((ap2 = this.b.getApByMac(string)) != null && ap2.getStatus() == 1 && !l.a((long)ap2.getLastSeen(), (long)450000L)) {
                    bl = true;
                }
                if (ap2 != null && ap2.getStatus() == 0 && l.a((long)ap2.getLastSeen(), (long)(com.tp_link.eap.c.a.a * 1000))) {
                    bl = false;
                }
                if (!bl) continue;
                ++n2;
            }
        }
        return n2;
    }

    @Override
    public List<CandidateParentApInfo> filterCandidateParents(String mac) {
        ArrayList<CandidateParentApInfo> arrayList = new ArrayList<CandidateParentApInfo>();
        List list = new ArrayList();
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(mac);
        Ap ap = this.b.getApByMac(mac);
        if (statMeshInfo != null) {
            list = statMeshInfo.getCandidateParentAps();
        } else {
            h.debug("StatMeshInfo is null");
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string = ((CandidateParentApInfo)list.get(i2)).getMac();
                boolean bl = false;
                if (string.equals(mac) || ap != null && (ap.getStatus() == 2 || ap.getStatus() == 4) && (((CandidateParentApInfo)list.get(i2)).getUptime() == null || l.a((long)((CandidateParentApInfo)list.get(i2)).getUptime().getTime(), (long)120000L))) continue;
                int n2 = 0;
                String string2 = null;
                int n3 = -1;
                Ap ap2 = this.b.getApByMac(string);
                if (ap2 != null && ap2.getSite().equals(com.tp_link.eap.d.b.a()) && ap2.getStatus() == 1) {
                    bl = true;
                    if (ap2.getMeshConf() != null && ap2.getMeshConf().getChildApMacs() != null) {
                        n2 = ap2.getMeshConf().getChildApMacs().size();
                        n2 -= this.getDisChildNum(ap2);
                        string2 = ap2.getName();
                        if (ap2.getWp5g() != null && !com.tp_link.eap.util.a.e.a((String)ap2.getWp5g().getActualChannel())) {
                            n3 = l.h((String)ap2.getWp5g().getActualChannel());
                        }
                    }
                }
                if (!bl || ap2.getRealtimeStatus() != RealtimeStatus.a.ordinal() && ap2.getRealtimeStatus() != RealtimeStatus.d.ordinal()) continue;
                int n4 = 0;
                n4 = this.getHop(string);
                if (n4 > 3 || this.isOffspring(mac, string)) continue;
                ((CandidateParentApInfo)list.get(i2)).setHop(Integer.valueOf(n4));
                ((CandidateParentApInfo)list.get(i2)).setChildsNum(Integer.valueOf(n2));
                ((CandidateParentApInfo)list.get(i2)).setApName(string2);
                if (n3 >= 0) {
                    ((CandidateParentApInfo)list.get(i2)).setChannel(Integer.valueOf(n3));
                }
                arrayList.add((CandidateParentApInfo)list.get(i2));
            }
        }
        return arrayList;
    }

    @Override
    public int getHop(String mac) {
        int n2 = 0;
        if (!com.tp_link.eap.util.a.e.a((String)mac)) {
            Ap ap = this.b.getApByMac(mac);
            while (ap != null && ap.getWirelessLinked().booleanValue() && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
                ++n2;
                mac = ap.getMeshConf().getParentApMac();
                ap = this.b.getApByMac(mac);
            }
        }
        return n2;
    }

    @Override
    public int getGenerations(String mac) {
        int n2 = 1;
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        this.getOffspring(mac, hashSet);
        if (hashSet != null) {
            for (String string : hashSet) {
                int n4 = this.getHop(string);
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        if (n3 > 0) {
            n2 = n3 - this.getHop(mac) + 1;
        }
        h.debug("mac: " + mac + "generations: " + n2);
        return n2;
    }

    @Override
    public Map<Integer, Set<String>> getHopMap(List<String> macList) {
        HashMap<Integer, Set<String>> hashMap = new HashMap<Integer, Set<String>>();
        if (!CollectionUtils.isEmpty(macList)) {
            for (String string : macList) {
                int n2 = this.getHop(string);
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(n2);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string);
                hashMap.put(n2, hashSet);
            }
        }
        return hashMap;
    }

    @Override
    public Map<Integer, List<MeshRelation>> getApMapByHop(List<String> macList) {
        HashMap<Integer, List<MeshRelation>> hashMap = new HashMap<Integer, List<MeshRelation>>();
        if (!CollectionUtils.isEmpty(macList)) {
            for (String string : macList) {
                Ap ap = this.b.getApByMac(string);
                if (ap == null) continue;
                int n2 = this.getHop(ap.getMac());
                ArrayList<MeshRelation> arrayList = (ArrayList<MeshRelation>)hashMap.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<MeshRelation>();
                }
                MeshRelation meshRelation = new MeshRelation();
                meshRelation.setMac(ap.getMac());
                meshRelation.setStatus(ap.getStatus());
                meshRelation.setHop(Integer.valueOf(n2));
                arrayList.add(meshRelation);
                hashMap.put(n2, arrayList);
            }
        }
        return hashMap;
    }

    @Override
    public Map<Integer, List<MeshRelation>> getApMapByHop(String site) {
        HashMap<Integer, List<MeshRelation>> hashMap = new HashMap<Integer, List<MeshRelation>>();
        List<Ap> list = this.b.getSiteAdoptedAps(site);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                int n2 = this.getHop(ap.getMac());
                ArrayList<MeshRelation> arrayList = (ArrayList<MeshRelation>)hashMap.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<MeshRelation>();
                }
                MeshRelation meshRelation = new MeshRelation();
                meshRelation.setMac(ap.getMac());
                meshRelation.setStatus(ap.getStatus());
                meshRelation.setHop(Integer.valueOf(n2));
                arrayList.add(meshRelation);
                hashMap.put(n2, arrayList);
            }
        }
        return hashMap;
    }

    @Override
    public boolean isOffspring(String parentMac, String childMac) {
        HashSet<String> hashSet = new HashSet<String>();
        this.getOffspring(parentMac, hashSet);
        h.debug("parentMac: {} children: {}", (Object)parentMac, hashSet);
        return hashSet.contains(childMac);
    }

    @Override
    public boolean isChild(String parentMac, String childMac) {
        Set set = new HashSet();
        Ap ap = this.b.getApByMac(parentMac);
        if (ap != null && ap.getMeshConf() != null && ap.getMeshConf().getChildApMacs() != null) {
            set = ap.getMeshConf().getChildApMacs();
        }
        return set.contains(childMac);
    }

    @Override
    public void getOffspring(String mac, Set<String> re) {
        Ap ap = this.b.getApByMac(mac);
        if (ap.getMeshConf() != null && ap.getMeshConf().getChildApMacs() != null) {
            re.addAll(ap.getMeshConf().getChildApMacs());
            for (String string : ap.getMeshConf().getChildApMacs()) {
                this.getOffspring(string, re);
            }
        }
    }

    private long a(long l2, long l3, long l4, long l5) {
        long l6 = l2 - l4 + l3 - l5;
        l6 = l6 < 0L ? 0L : l6;
        return (long)Math.ceil(l6 / 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUplink(String mac) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.p((String)mac);
        synchronized (object2) {
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(mac);
            if (statMeshInfo != null) {
                statMeshInfo.setStatus(Integer.valueOf(0));
                statMeshInfo.setTryParent("");
                this.saveStatMesh(statMeshInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInvalidCadidate(String mac) {
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.p((String)mac);
        synchronized (object2) {
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(mac);
            Ap ap = this.b.getApByMac(mac);
            String string = null;
            if (ap != null && ap.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap.getMeshConf().getParentApMac())) {
                string = ap.getMeshConf().getParentApMac();
            }
            if (statMeshInfo != null) {
                List list = statMeshInfo.getCandidateParentAps();
                ArrayList<CandidateParentApInfo> arrayList = new ArrayList<CandidateParentApInfo>();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    for (CandidateParentApInfo candidateParentApInfo : list) {
                        boolean bl = true;
                        if (!com.tp_link.eap.util.a.e.a((String)string) && candidateParentApInfo.getMac().equals(string) || !com.tp_link.eap.util.a.e.a((String)statMeshInfo.getTryParent()) && candidateParentApInfo.getMac().equals(statMeshInfo.getTryParent())) {
                            bl = true;
                        } else {
                            Ap ap2 = this.b.getApByMac(candidateParentApInfo.getMac());
                            if (ap2 == null || ap2.getStatus() != 1) {
                                bl = false;
                            }
                            if (bl && ap != null && ap.getSite() != null && !ap.getSite().equals("PENDING-SITE") && ap2 != null && ap2.getSite() != null && !ap.getSite().equals(ap2.getSite())) {
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        arrayList.add(candidateParentApInfo);
                    }
                    statMeshInfo.setCandidateParentAps(arrayList);
                    this.saveStatMesh(statMeshInfo);
                }
            }
        }
    }

    @Override
    public int getDisChildNum(Ap parentAp) {
        int n2 = 0;
        MeshConf meshConf = parentAp.getMeshConf();
        if (meshConf == null || meshConf.getChildApMacs() == null) {
            return 0;
        }
        Set set = meshConf.getChildApMacs();
        for (String string : set) {
            Ap ap = this.b.getApByMac(string);
            if (ap == null || ap.getStatus() != 0 || !l.a((long)ap.getLastSeen(), (long)(com.tp_link.eap.c.a.a * 1000))) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public String giveDisChild(Ap parentAp) {
        String string = null;
        MeshConf meshConf = parentAp.getMeshConf();
        if (meshConf == null || meshConf.getChildApMacs() == null) {
            return string;
        }
        Set set = meshConf.getChildApMacs();
        long l2 = 0L;
        for (String string2 : set) {
            Ap ap = this.b.getApByMac(string2);
            if (ap == null || ap.getStatus() != 0 || !l.a((long)ap.getLastSeen(), (long)(com.tp_link.eap.c.a.a * 1000))) continue;
            if (l2 == 0L) {
                l2 = ap.getLastSeen();
                string = string2;
            }
            if (ap.getLastSeen() >= l2) continue;
            string = string2;
        }
        return string;
    }

    @Override
    public int calcChildApCnt(Ap parentAp) {
        MeshConf meshConf = parentAp.getMeshConf();
        if (meshConf == null || meshConf.getChildApMacs() == null) {
            return 0;
        }
        return meshConf.getChildApMacs().size();
    }

    private void a(Ap ap, String string) {
        h.debug("deleteOverOffspring");
        int n2 = this.getGenerations(ap.getMac());
        int n3 = this.getHop(ap.getMac());
        int n4 = this.getHop(string);
        if (n2 + n4 > 3) {
            ArrayList<MeshRelation> arrayList = new ArrayList<MeshRelation>();
            this.getOffspringMeshRelations(ap.getMac(), arrayList);
            ArrayList<MeshRelation> arrayList2 = new ArrayList<MeshRelation>();
            if (!CollectionUtils.isEmpty(arrayList)) {
                int n5 = n4 + 1;
                for (MeshRelation meshRelation : arrayList) {
                    int n6;
                    int n7 = meshRelation.getHop() - n3;
                    if (n7 <= 0 || (n6 = n5 + n7) <= 3) continue;
                    arrayList2.add(meshRelation);
                }
            }
            if (!CollectionUtils.isEmpty(arrayList2)) {
                Collections.sort(arrayList2, new a(this));
                for (MeshRelation meshRelation : arrayList2) {
                    h.debug("mac : {}, parent: {} hop: {}", new Object[]{meshRelation.getMac(), meshRelation.getParentMac(), meshRelation.getHop()});
                    if (com.tp_link.eap.util.a.e.a((String)meshRelation.getMac()) || com.tp_link.eap.util.a.e.a((String)meshRelation.getParentMac())) continue;
                    this.disConnectParentAp(meshRelation.getMac(), meshRelation.getParentMac(), false, true, false);
                }
            }
        }
    }

    @Override
    public void getOffspringMeshRelations(String mac, List<MeshRelation> relation) {
        Ap ap = this.b.getApByMac(mac);
        if (ap != null && ap.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) {
            int n2 = this.getHop(mac);
            for (String string : ap.getMeshConf().getChildApMacs()) {
                if (com.tp_link.eap.util.a.e.a((String)string)) continue;
                MeshRelation meshRelation = new MeshRelation();
                meshRelation.setMac(string);
                meshRelation.setParentMac(mac);
                meshRelation.setHop(Integer.valueOf(n2 + 1));
                relation.add(meshRelation);
                this.getOffspringMeshRelations(string, relation);
            }
        }
    }

    @Override
    public void sendBatchDisconnectCommand(String parentMac, Set<String> childApMacs) {
        Object object;
        String string2;
        if (com.tp_link.eap.util.a.e.a((String)parentMac) || CollectionUtils.isEmpty(childApMacs)) {
            return;
        }
        ArrayList<ConfigChildAP> arrayList = new ArrayList<ConfigChildAP>();
        for (String string2 : childApMacs) {
            object = new ConfigChildAP();
            object.setMac(string2);
            object.setAction(Integer.valueOf(0));
            arrayList.add((ConfigChildAP)object);
        }
        Mesh mesh = new Mesh();
        mesh.setConfigChildAPList(arrayList);
        string2 = new EapConfigBody();
        string2.setMesh(mesh);
        string2.setSequenceId(Integer.valueOf(65539));
        if (this.e.getSettingVersion(parentMac) != null) {
            object = this.e.getSettingVersion(parentMac).getBase();
            string2.setConfigVersion((Integer)object);
        }
        com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, string2, parentMac);
    }

    @Override
    public List<StatMeshInfo> getListByStatus(Integer status) {
        return this.a.findByStatus(status);
    }

    public List<StatMeshInfo> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<StatMeshInfo> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<StatMeshInfo> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public List<StatMeshInfo> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    @Override
    public void clearInvalidCadidate() {
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject basicDBObject2 = new BasicDBObject();
        basicDBObject2.put("candidateParentAps", (Object)false);
        BasicQuery basicQuery = new BasicQuery((DBObject)basicDBObject, (DBObject)basicDBObject2);
        basicQuery.addCriteria(Criteria.where((String)"candidateParentAps").exists(true));
        List list = this.g.find((Query)basicQuery, StatMeshInfo.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (StatMeshInfo statMeshInfo : list) {
                this.removeInvalidCadidate(statMeshInfo.getMac());
            }
        }
    }

    @Override
    public OperationResponse getMeshStastic(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.b.getApByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        MeshStatistics meshStatistics = new MeshStatistics();
        ap.setAdoptInfo(null);
        ap.setSsidOverrides(null);
        ap.setSsidOverrides5g(null);
        ap.setLoadBalance(null);
        ap.setLoadBalance5g(null);
        ap.setIpSetting(null);
        meshStatistics.setAp(ap);
        meshStatistics.setScanStatus(Integer.valueOf(MeshScanStatus.getStatus((String)string)));
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(string);
        if (statMeshInfo != null) {
            meshStatistics.setUplinkInfo(statMeshInfo.getUplinkInfo());
            meshStatistics.setLinkStatus(statMeshInfo.getStatus());
        }
        if (meshStatistics.getLinkStatus() == null) {
            meshStatistics.setLinkStatus(Integer.valueOf(0));
        }
        if (meshStatistics.getScanStatus() == null) {
            meshStatistics.setScanStatus(Integer.valueOf(0));
        }
        QueryData queryData = new QueryData();
        Grid grid = new Grid(queryData);
        List<ChildAP> list = this.getChildAps(string);
        grid.setData(list);
        grid.setTotalRows((long)list.size());
        meshStatistics.setChildGrid(grid);
        return new OperationResponse(ResErrorCode.a, (Object)meshStatistics);
    }

    @Override
    public OperationResponse getCandidateParents(ControlType controlType, JSONObject reqObj) {
        int n2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        int n3 = 0;
        List<Object> list = new ArrayList();
        List<Object> list2 = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n4 = queryData.getCurrentPage();
        int n5 = queryData.getCurrentPageSize();
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            queryData.setSortName("rssi");
            queryData.setSortOrder("desc");
        } else {
            queryData.setSortName(string);
        }
        String string2 = queryData.getSortOrder();
        Map map = queryData.getFilters();
        Object v = map.get("mac");
        String string3 = (String)v;
        Grid grid = new Grid(queryData);
        grid.setData(arrayList);
        grid.setTotalRows((long)n3);
        if (string3 == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        Ap ap = this.b.getApByMac(string3);
        if (ap == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        list = this.filterCandidateParents(string3);
        n3 = list.size();
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(string3);
        int n6 = 0;
        String string4 = "";
        Ap ap2 = null;
        CandidateParentApInfo candidateParentApInfo = null;
        if (statMeshInfo != null) {
            List list3;
            n6 = statMeshInfo.getStatus();
            string4 = statMeshInfo.getTryParent();
            if (!com.tp_link.eap.util.a.e.a((String)string4)) {
                ap2 = this.b.getApByMac(string4);
            }
            if (list != null && !list.isEmpty() && !com.tp_link.eap.util.a.e.a((String)string4)) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    String string5 = ((CandidateParentApInfo)list.get(n2)).getMac();
                    if (!string5.equals(string4)) continue;
                    boolean bl = true;
                    if (n6 == 0) {
                        bl = false;
                    } else if (n6 == 3) {
                        bl = true;
                    } else if (n6 == 1) {
                        bl = true;
                    } else if (n6 == 2) {
                        bl = true;
                        if (this.isChild(string4, string3)) {
                            UplinkInfo uplinkInfo = statMeshInfo.getUplinkInfo();
                            n6 = uplinkInfo != null && uplinkInfo.getMac().equals(string4) && !l.a((long)uplinkInfo.getUptime().getTime(), (long)120000L) ? 2 : 4;
                        } else {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    ((CandidateParentApInfo)list.get(n2)).setMac(string5);
                    ((CandidateParentApInfo)list.get(n2)).setBeTryParent(true);
                    ((CandidateParentApInfo)list.get(n2)).setLinkStatus(n6);
                    if (n6 == 4) {
                        ((CandidateParentApInfo)list.get(n2)).setRssi(null);
                        ((CandidateParentApInfo)list.get(n2)).setHop(null);
                        ((CandidateParentApInfo)list.get(n2)).setChildsNum(null);
                    }
                    candidateParentApInfo = (CandidateParentApInfo)list.get(n2);
                    list.remove(n2);
                    break;
                }
            }
            if (candidateParentApInfo == null && (list3 = statMeshInfo.getCandidateParentAps()) != null) {
                for (int i2 = 0; i2 < list3.size(); ++i2) {
                    String string6 = ((CandidateParentApInfo)list3.get(i2)).getMac();
                    if (com.tp_link.eap.util.a.e.a((String)string4) || !string6.equals(string4) || !this.isChild(string4, string3)) continue;
                    ((CandidateParentApInfo)list3.get(i2)).setMac(string6);
                    if (ap2 != null) {
                        ((CandidateParentApInfo)list3.get(i2)).setApName(ap2.getName());
                    }
                    ((CandidateParentApInfo)list3.get(i2)).setBeTryParent(true);
                    ((CandidateParentApInfo)list3.get(i2)).setLinkStatus(4);
                    ((CandidateParentApInfo)list3.get(i2)).setRssi(null);
                    ((CandidateParentApInfo)list3.get(i2)).setHop(null);
                    ((CandidateParentApInfo)list3.get(i2)).setChildsNum(null);
                    candidateParentApInfo = (CandidateParentApInfo)list3.get(i2);
                    ++n3;
                }
            }
        }
        if (n3 > 0) {
            int n7;
            if (n3 > 1 && string != null && !string.equals("")) {
                b<Object> b2 = new b<Object>(this);
                b2.a(list, "get" + string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1), string2.equals("desc"));
            }
            list2 = list;
            if (candidateParentApInfo != null) {
                int n8;
                Ap ap3;
                if (candidateParentApInfo.isBeTryParent() && (ap3 = this.b.getApByMac(string3)) != null && ap3.getStatus() == 1 && ap3.getWp5g() != null && !com.tp_link.eap.util.a.e.a((String)ap3.getWp5g().getActualChannel()) && (n8 = l.h((String)ap3.getWp5g().getActualChannel())) >= 0) {
                    candidateParentApInfo.setChannel(Integer.valueOf(n8));
                }
                list2.add(0, candidateParentApInfo);
            }
            if ((n7 = (n2 = (n4 - 1) * n5) + n5) > n3) {
                n7 = n3;
            }
            if (n2 >= n7) {
                n2 = 0;
                n7 = n3 > n5 ? n5 - 1 : n3;
                queryData.setCurrentPage(1);
            }
            for (int i3 = n2; i3 < n7; ++i3) {
                arrayList.add(list2.get(i3));
            }
        }
        grid = new Grid(queryData);
        grid.setData(arrayList);
        grid.setTotalRows((long)n3);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getChildAps(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Map map = queryData.getFilters();
        Object v = map.get("mac");
        String string = (String)v;
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Grid grid = new Grid(queryData);
        List<Object> list = new ArrayList();
        list = this.getChildAps(string);
        grid.setData(list);
        grid.setTotalRows((long)list.size());
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse changeParentAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("childMac", null);
        String string2 = jSONObject.optString("newParentMac", null);
        String string3 = jSONObject.optString("username", null);
        String string4 = jSONObject.optString("password", null);
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.changeParentAp(string, string2, string3, string4);
    }

    @Override
    public OperationResponse isValidParentAp(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("childMac", null);
        String string2 = jSONObject.optString("newParentMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return com.tp_link.eap.util.e.aZ;
        }
        StatMeshInfo statMeshInfo = this.getStatMeshByMac(string);
        if (statMeshInfo != null && statMeshInfo.getStatus() == 1) {
            return new OperationResponse(ResErrorCode.dz);
        }
        Ap ap = this.b.getApByMac(string);
        if (ap == null) {
            return new OperationResponse(ResErrorCode.dA);
        }
        if (!ap.getWirelessLinked().booleanValue() || ap.getStatus() == 1 && ap.getRealtimeStatus() != RealtimeStatus.a.ordinal() && ap.getRealtimeStatus() != RealtimeStatus.d.ordinal()) {
            return new OperationResponse(ResErrorCode.dC);
        }
        Ap ap2 = this.b.getApByMac(string2);
        return this.isValidParent(ap, ap2);
    }

    @Override
    public OperationResponse refreshCandidateParents(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("childMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.refreshCandidateParents(string);
    }

    @Override
    public OperationResponse getApUplink(ControlType controlType, JSONObject reqObj) {
        String string;
        Ap ap;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = jSONObject.optString("apMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap2 = this.b.getApByMac(string2);
        if (ap2 == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        CandidateParentApInfo candidateParentApInfo = new CandidateParentApInfo();
        candidateParentApInfo.setWirelessLinked(ap2.getWirelessLinked());
        candidateParentApInfo.setApName("");
        candidateParentApInfo.setHop(Integer.valueOf(0));
        candidateParentApInfo.setChildsNum(Integer.valueOf(0));
        if (ap2 != null && ap2.getWirelessLinked().booleanValue() && ap2.getMeshConf() != null && !com.tp_link.eap.util.a.e.a((String)ap2.getMeshConf().getParentApMac()) && (ap = this.b.getApByMac(string = ap2.getMeshConf().getParentApMac())) != null) {
            candidateParentApInfo.setMac(ap.getMac());
            candidateParentApInfo.setApName(ap.getName());
            candidateParentApInfo.setHop(Integer.valueOf(this.getHop(string)));
            if (ap.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)ap.getMeshConf().getChildApMacs())) {
                candidateParentApInfo.setChildsNum(Integer.valueOf(ap.getMeshConf().getChildApMacs().size()));
            }
            if (ap.getWp5g() != null && !com.tp_link.eap.util.a.e.a((String)ap.getWp5g().getActualChannel())) {
                candidateParentApInfo.setChannel(Integer.valueOf(l.h((String)ap.getWp5g().getActualChannel())));
            }
            candidateParentApInfo.setBeTryParent(true);
            StatMeshInfo statMeshInfo = this.getStatMeshByMac(string2);
            if (statMeshInfo != null && !CollectionUtils.isEmpty((Collection)statMeshInfo.getCandidateParentAps())) {
                for (CandidateParentApInfo candidateParentApInfo2 : statMeshInfo.getCandidateParentAps()) {
                    if (!candidateParentApInfo2.getMac().equals(string)) continue;
                    candidateParentApInfo.setRssi(candidateParentApInfo2.getRssi());
                    candidateParentApInfo.setSnr(candidateParentApInfo2.getSnr());
                    break;
                }
            }
        }
        return new OperationResponse(ResErrorCode.a, (Object)candidateParentApInfo);
    }

    @Override
    public OperationResponse getApDownlink(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            h.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("apMac", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ap ap = this.b.getApByMac(string);
        if (ap == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        List<Object> list = new ArrayList();
        list = this.getChildAps(string);
        HashMap hashMap = new HashMap();
        hashMap.put("data", list);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    static /* synthetic */ Logger a() {
        return h;
    }
}

